#!/bin/sh

confpath=/usr/local/lsws/conf

function removeLSPHPConf(){
    lhn=`grep -n $1 $confpath/httpd_config.xml | cut -f1 -d:`
    totallines=`wc -l $confpath/httpd_config.xml| cut -f1 -d" "`
    restlines=$((totallines - lhn))
    lineoffset=`tail -n $restlines  $confpath/httpd_config.xml | grep -m1 -n "</extProcessor>" | cut -f1 -d:`
    linestart=$((lhn - 2))
    lineend=$((lhn+lineoffset))
    sed -i "${linestart},${lineend}d" $confpath/httpd_config.xml
}

function removeLSPHPHandler(){
 lhn=`grep -n $1 $confpath/httpd_config.xml | cut -f1 -d:`
 totallines=`wc -l $confpath/httpd_config.xml| cut -f1 -d" "`
 restlines=$((totallines - lhn))
 lineoffset=`tail -n $restlines  $confpath/httpd_config.xml | grep -m1 -n "</scriptHandler>" | cut -f1 -d:`
 linestart=$((lhn-1))
 lineend=$((lhn+lineoffset))
 sed -i "${linestart},${lineend}d" $confpath/httpd_config.xml
}

#main conversion script

#Backup the configuration file
now=$(date +"%Y%m%d")
yes | cp -p $confpath/httpd_config.xml $confpath/httpd_config.xml.ea4.$now

#Detect and remove any EasyApache 3 incompatible configurations
if grep -q '<name>lsphp54</name>' $confpath/httpd_config.xml
then
    removeLSPHPConf '<name>lsphp54</name>'
fi

if grep -q '<name>lsphp55</name>' $confpath/httpd_config.xml
then
    removeLSPHPConf '<name>lsphp55</name>'
fi

if grep -q '<name>lsphp56</name>' $confpath/httpd_config.xml
then
    removeLSPHPConf '<name>lsphp56</name>'
fi

if grep -q '<name>lsphp70</name>' $confpath/httpd_config.xml
then
    removeLSPHPConf '<name>lsphp70</name>'
fi

if grep -q '<name>lsphp71</name>' $confpath/httpd_config.xml
then
    removeLSPHPConf '<name>lsphp71</name>'
fi

if grep -q '<name>lsphp72</name>' $confpath/httpd_config.xml
then
    removeLSPHPConf '<name>lsphp72</name>'
fi

#Detect and remove any EasyApache 3 incompatible Handlers
if grep -q '<suffix>php54</suffix>' $confpath/httpd_config.xml
then
    removeLSPHPHandler '<suffix>php54</suffix>'
fi

if grep -q '<suffix>php55</suffix>' $confpath/httpd_config.xml
then
    removeLSPHPHandler '<suffix>php55</suffix>'
fi

if grep -q '<suffix>php56</suffix>' $confpath/httpd_config.xml
then
    removeLSPHPHandler '<suffix>php56</suffix>'
fi

if grep -q '<suffix>php70</suffix>' $confpath/httpd_config.xml
then
    removeLSPHPHandler '<suffix>php70</suffix>'
fi

if grep -q '<suffix>php71</suffix>' $confpath/httpd_config.xml
then
    removeLSPHPHandler '<suffix>php71</suffix>'
fi              

if grep -q '<suffix>php72</suffix>' $confpath/httpd_config.xml
then
    removeLSPHPHandler '<suffix>php72</suffix>'
fi       

#restart LiteSpeed Web Server
service lsws restart