import os
import sys
sys.path.insert(0,'/usr/local/cpanel/scripts/cpnginx')
from  shellcolor import shellcolor
import datetime
import subprocess
import core
import conf
import re

def option_usage():
    now = datetime.datetime.now()
    print ("Copyright (C) 2009-"+str(now.year)+", Syslint Technologies India(P) LTD.")
    print ("Visit : https://cpnginx.com")
    print ("Usage: nginxctl [options] <command>  [parameters]\n")
    print ("""nginxctl build [options] 
            vhosts      -   To build all nginx vhosts
            sslcerts    -   To build all nginx ssl certificates
            remoteip    -   To  install apache mod_remoteip module and settings
            """)
    print ("""nginxctl nginxbuild [option1=value1] [option2] ..
                    --version=Version       - Chose your own nginx version
                    --enable-pagespeed      - To build the page speeed module with nginx
                    --enable-modsec         - To build mod_security """)
    print ("""nginxctl mosecurityrules <option> <value>
                    install < vendor >    -  Install a modsecurity rule from the vendor
                                            ( eg : install owasp )
                    remove  < vendor >   -   Remove installed modsecurity vendor rules""") 
    print ("nginxctl setupphpfpm")
    print ("nginxctl rebuildvhost  <domain name>")
    print ("nginxctl rmvhost  <domain name>")
    print ("nginxctl rebuilduservhost  <cpanel user  name>")
    print ("nginxctl rmuservhost  <cpanel user  name>")
    print ("nginxctl templaterebuild ")
    print ("nginxctl restart ")
    print ("nginxctl help ")
    print ("nginxctl enable") 
    print ("nginxctl disable")
    print ("nginxctl status")
    print ("nginxctl cleanfpm")
    print ("nginxctl version")

def invalid_option():
    print (shellcolor.warning+"Invalid option(s). Please enter the complete options"+shellcolor.end)
    option_usage()
    sys.exit()



def  incomplete_option():
    print (shellcolor.warning+"Incomplete option(s). Please enter the complete options"+shellcolor.end)
    option_usage()
    sys.exit()

def parse_arguments(argus):
    length= len(argus)
    options={}
    if argus[0] == "build":
        if length == 2:
            options['build']=[argus[0],argus[1]]
        elif length == 4:
            options['build']=[argus[0],argus[1],argus[2],argus[3]]
        else:
            incomplete_option()
    elif argus[0] == "nginxbuild":
        odata=[]
        for opt in argus:
            odata.append(opt)
        odata.remove('nginxbuild')
        options['nginxbuild']=odata
    elif  argus[0] == "mosecurityrules":
        odata=[]
        for opt in argus:
            odata.append(opt)
        odata.remove('mosecurityrules')
        options['mosecurityrules']=odata
    elif argus[0] == "rebuildvhost" or argus[0] == "rebuilduservhost" or argus[0] == "rmuservhost" or argus[0] =="rmvhost":
        if length == 2:
            options[argus[0]]=[argus[0],argus[1]]
        else:
            incomplete_option()
    elif argus[0] == "restart" or argus[0] == "help" or argus[0] == "enable" or argus[0] == "disable"  or argus[0] == "status"  or argus[0] == "version" or argus[0] == "setupphpfpm" or  argus[0] == "templaterebuild" or argus[0] == "cleanfpm":
        if length == 1:
            options[argus[0]]=[argus[0]]
        else:
            invalid_option()
    else:
        invalid_option()
    return options
def options():
    argus = sys.argv[1:]
    if not sys.argv[1:]:
        option_usage()
        sys.exit()
    cmd=parse_arguments(argus)
    for command in cmd:
        if command == "build":
            argc=len(cmd[command])
            if argc == 2:
                if cmd[command][1]=="nginx":
                    invalid_option()
                elif cmd[command][1]=="vhosts":
                    core.rebuild_all_vhost()
                elif cmd[command][1]=="sslcerts":
                    core.buildsslcerts()
                elif cmd[command][1]=="remoteip":
                    core.buildremoteip()
                else:
                    invalid_option()
            elif argc == 4:
                if cmd[command][1]=="nginx" and  cmd[command][2]=="--version":
                    nversion=cmd[command][3].strip()
                    core.install_nginx(nversion)
                else:
                    invalid_option()
            else:
                invalid_option()
        elif command == "mosecurityrules":
            argc=len(cmd[command])
            if argc == 2:
                setopt=[]
                for opt in cmd[command]:
                    setopt.append(opt)
                core.install_modsecurityrules(setopt)
            else:
                invalid_option()
        elif command == "nginxbuild":
            setopt=[]
            for opt in cmd[command]:
                setopt.append(opt)
            core.install_nginx(setopt)
        elif command == "rebuildvhost":
            rvhdom=cmd[command][1]
            core.rebuildvhost(rvhdom)
        elif command == "rmvhost":
            rvhdom=cmd[command][1]
            core.rmvhost(rvhdom)
        elif command == "rebuilduservhost":
            cpuser=cmd[command][1]
            core.rebuilduservhost(cpuser)
        elif command == "rmuservhost":
            cpuser=cmd[command][1]
            core.rmuservhost(cpuser)
        elif command == "templaterebuild":
            core.templaterebuild()
        elif command == "restart":
            core.restart()
        elif command == "setupphpfpm":
            core.setupphpfpm()
        elif command == "help":
            option_usage()
        elif command == "enable":
            core.enable()
        elif command == "disable":
            core.disable()
        elif command == "status":
            core.status()
        elif command == "cleanfpm":
            core.cleanfpm()
        elif command == "version":
            core.version()
        else:
            invalid_option()

